ej_timer2.c
/*
Exemple d'utilisation des fonctions du module TIMER2.
valide pour la famille 16f87Xa,
Dans  cet exemple on utilise le timer2 avec un compteur par logiciel,
pour faire une led clignotante:
connecter une led ou autre sortie à RB7.
RB7 se mettra à l'état haut (Vdd) durant approximativement 1 seconde avec une horloge de 4 MHz, et à  l'état bas durant une autre seconde.
*/
#include <pic/p16f877a.h>
#include <timer2.h>
int main(void)
 {
   unsigned char compteur;
   TRISBbits.TRISB7 = 0;
   PORTBbits.RB7 = 0;
   timer2_init();                        // Initialise le timer2
   timer2_set_prescaler(PRESC_DIV_16);   // Établit le pré-diviseur en fréquence d'instructions
   timer2_set_period(255);               // Établit la période à 255
   compteur = 0;
   bucle:
   while (timer2_read() < 255);          // Attend ici tant que le compteur du timer <255 
   compteur = compteur + 1;              // Incrémente le compteur
   if (compteur == 255)                  // Si compteur = 255 inverse l'état de RB7
     {
       if (PORTBbits.RB7 == 0)
           PORTBbits.RB7 = 1;
       else
           PORTBbits.RB7 = 0;
       compteur = 0;                    // Reinitialise le compteur
     }
   goto bucle;
 }
