/* Exemple d'utilisation des fonctions du module TIMER0,
 valide pour la famille 16f87Xa,
Dans cet exemple on utilise le timer0 comme compteur,
connecter un bouton poussoir entre RA4 y 0V
et une résistance de tirage vers le haut (pullup) 
de 5 Kohms entre RA4 y Vdd (+5v),
connecter une led ou une autre sortie à RB7.
RB7 se mettra à l'état haut (Vdd) quand on appuie 4 fois. */
#include <pic/p16f877a.h>
#include <timer0.h>

int main(void)
 {
   TRISAbits.TRISA4 = 1;
   TRISBbits.TRISB7 = 0;
   PORTBbits.RB7 = 0;
   timer0_init(COUNTER_EXTERN); 
   // Initialise timer0 mode compteur (horloge ou stímuli externe en RA4)
   timer0_set_edge(FAL_EDGE); // indique l'incrément du compteur sur front descendant
   timer0_set_prescaler(PRESC_DIV_2); 
   // établit  le pré-diviseur (prescaler) en fréquence d'instructions / 2
   while (timer0_read() < 2); // Attends ici tant que le compteur du timer < 2
   PORTBbits.RB7 = 1;
 }
